/////////////////////////////////////////////////////////////////////////
// WDL prefabs for displaying messages //////////
///////// ABGEAENDERT ////////////////////////
////////////////////////////////////////////////////////////////////////

IFNDEF MSG_DEFS;
 FONT standard_font,<ackfont.pcx>,6,9;

 DEFINE MSG_X,4;		// from left
 DEFINE MSG_Y,4;		// from above
 DEFINE BLINK_TICKS,6;	// msg blinking period
 DEFINE MSG_TICKS,64;	// msg appearing time
// DEFINE msg_font,standard_font; <- vorher
 FONT msg_font,<msgfont.pcx>,12,16; // nachher

 SOUND msg_sound,<msg.wav>;

 DEFINE PANEL_POSX,4;	// health panel from left
 DEFINE PANEL_POSY,-20;	// from below
 FONT digit_font,<digfont.pcx>,12,16;	// ammo/health font
ENDIF;

IFNDEF MSG_DEFS2;
 DEFINE SCROLL_X,4;		// scroll text from left
 DEFINE SCROLL_Y,4;		// from above
 DEFINE SCROLL_LINES,4;	// maximum 8;
ENDIF;

IFNDEF MSG_DEFS3;

 DEFINE touch_font,standard_font;
 DEFINE touch_sound,msg_sound;
ENDIF;

//////////////////////////////////////////////////////////////////////
var msg_counter = 0;
STRING empty_str[240];
STRING temp_str[240];

TEXT msg
{
	POS_X MSG_X;
	POS_Y MSG_Y;
	FONT	msg_font;
	STRING empty_str;
}

//////////////////////////////////////////////////////////////////////
// To display a message string for a given number of seconds, perform the instructions
// msg_show(string,time);

function msg_show(str,secs)
{
	exclusive_global;		// stop previous msg_show action
	play_sound(msg_sound,66);
	msg.string = str;
	msg.visible = on;
	waitt(secs*16);
	msg.string = empty_str;
	msg.visible = off;
}

function show_message()
{
	msg_show(msg.string,3);
}

// The same, but message will blink
function msg_blink(str,secs)
{
//	ME = NULL;
	exclusive_global;
	play_sound(msg_sound,66);
	msg.string = str;
	msg_counter = secs*16;
	while(msg_counter > 0)
	{
		msg.visible = (msg.visible == off);
		waitt(BLINK_TICKS);
		msg_counter -= BLINK_TICKS;
	}
	msg.string = empty_str;
	msg.visible = off;
}

function blink_message()
{
	msg_blink(msg.string,5);
}

//////////////////////////////////////////////////////////////////////
// actions for scrolling messages
//////////////////////////////////////////////////////////////////////
STRING message_str,
 "                                                                    ";
TEXT enter_txt
{
	FONT	msg_font;
	STRING message_str;
}

TEXT scroll
{
	POS_X MSG_X;
	POS_Y MSG_Y;
	FONT	msg_font;
	STRINGS 8;
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	STRING "                                                           ";
	INDEX SCROLL_LINES;
}

string* scroll_string;

// Desc: scroll message upwards while adding a line
// Mod Date: 14/03/01 JCL - str parameter added
function scroll_message(str)
{
	if (str) {
		str_cpy(scroll.STRING[SCROLL_LINES],str);
	}
	play_sound(msg_sound,66);
	scroll.VISIBLE = ON;
	temp = 1;
	while(temp <= SCROLL_LINES)
	{
	// scroll upwards by copying each string to the previous one
		str_cpy(scroll.STRING[temp-1],scroll.STRING[temp]);
		temp += 1;
	}
	// clear the last string
	str_cpy(scroll.STRING[SCROLL_LINES],empty_str);
}

string* message_syn = message_str;

//////////////////////////////////////////////////////////////////////
// actions for ammo and health panels
//////////////////////////////////////////////////////////////////////
var show_health = 0;
var ammo1 = 0;
var show_ammo = 0;
var kristall_zahl = 0; 

PANEL game_panel
{
	POS_X		PANEL_POSX;
//	DIGITS	40,0,3,msg_font,1,show_ammo;
	DIGITS	0,0,3,msg_font,1,show_health;
	DIGITS	40,0,3,msg_font,1,kristall_zahl;
//	DIGITS	80,0,3,msg_font,1,show_armor;
	FLAGS		TRANSPARENT,REFRESH;
}

//////////////////////////////////////////////////////////////////////

function show_panels()
{
	game_PANEL.VISIBLE = ON;
	while(1)
	{	// forever
		game_PANEL.POS_Y = SCREEN_SIZE.Y + PANEL_POSY;
		show_ammo = ammo1; 
		if(player != NULL)
		{
			show_health = player._HEALTH;
			kristall_zahl = kristall_zahl;
		}
		wait(1);
	}
}
		
//////////////////////////////////////////////////////////////////////
// Stuff for displaying object titles if the mouse touches them
TEXT touch_txt
{
	FONT	touch_font;
	STRING empty_str;
	FLAGS CENTER_X,CENTER_Y;
}

// Desc: display a touch text at mouse position
function _show_touch()
{
	if(MY.STRING1 != NULL)
	{
		play_sound(touch_sound,33);
		touch_txt.VISIBLE = ON;
		touch_txt.STRING = MY.STRING1;
		touch_txt.POS_X = MOUSE_POS.X;
		touch_txt.POS_Y = MOUSE_POS.Y;
		MY.ENABLE_RELEASE = ON;

	//	WHILE (touch_text.VISIBLE == ON)	// move text with mouse
	//	{
	//		touch_text.POSX = MOUSE_X;
	//		touch_text.POSY = MOUSE_Y;
	//		wait(1);
	//	}
	}
}

// Desc: hide touch text if it still displayed my string
function _hide_touch()
{
	if(touch_txt.STRING == MY.STRING1)
	{
		touch_txt.VISIBLE = OFF;
	}
}

// Desc: call this from a event action to operate the touch text
function handle_touch()
{
	if(EVENT_TYPE == EVENT_TOUCH) { _show_touch(); return; }
	if(EVENT_TYPE == EVENT_RELEASE) { _hide_touch(); return; }
}

//////////////////////////////////////////////////////////////////////

