var global = null
var vm
var current_context

func check_obj(name, cmd):
	var obj = vm.get_object(name)
	if obj == null:
		vm.report_errors("", ["Global id "+name+" not found for " + cmd])
		return false
	return true

func _walk(params, block):
	if !check_obj(params[0], "walk"):
		return vm.state_return
	if !check_obj(params[1], "walk"):
		return vm.state_return
	var tpos = vm.get_object(params[1]).get_global_pos()
	var speed = 0
	if params.size() > 2:
		speed = real(params[2])
	if block:
		current_context.waiting = true
		vm.get_object(params[0]).walk(tpos, speed, current_context)
		return vm.state_yield
	else:
		vm.get_object(params[0]).walk(tpos, speed)
		return vm.state_return

### commands

func set_global(params):
	vm.set_global(params[0], params[1])
	return vm.state_return

func debug(params):
	print(params[0])
	return vm.state_return

func anim(params):
	if !check_obj(params[0], "anim"):
		return vm.state_return
	var obj = vm.get_object(params[0])
	obj.play_anim(params[1])
	return vm.state_return

func set_state(params):
	var obj = vm.get_object(params[0])
	if obj != null:
		obj.set_state(params[1])
	vm.set_state(params[0], params[1])
	return vm.state_return

func say(params):
	if !check_obj(params[0], "say"):
		return vm.state_return
	current_context.waiting = true
	vm.say(params, current_context)
	return vm.state_yield

func dialog(params):
	current_context.waiting = true
	vm.dialog(params, current_context)
	return vm.state_yield

func cut_scene(params):
	if !check_obj(params[0], "cut_scene"):
		return vm.state_return
	var obj = vm.get_object(params[0])
	current_context.waiting = true
	obj.play_anim(params[1], current_context)
	return vm.state_yield

func branch(params):
	return vm.add_level(params, false)

func inventory_add(params):
	vm.inventory_set(params[0], true)
	return vm.state_return

func inventory_remove(params):
	vm.inventory_set(params[0], false)
	return vm.state_return

func set_active(params):
	var obj = vm.get_object(params[0])
	if obj != null:
		obj.set_active(params[1])
	vm.set_active(params[0], params[1])
	return vm.state_return

func stop(params):
	return vm.state_break

func repeat(params):
	return vm.state_repeat

func wait(params):
	return vm.wait(params, current_context)

func teleport(params):
	if !check_obj(params[0], "teleport"):
		return vm.state_return
	if !check_obj(params[1], "teleport"):
		return vm.state_return
	vm.get_object(params[0]).teleport(vm.get_object(params[1]))
	return vm.state_return

func teleport_pos(params):
	if !check_obj(params[0], "teleport_pos"):
		return vm.state_return
	vm.get_object(params[0]).teleport_pos(int(params[1]), int(params[2]))
	return vm.state_return


func walk(params):
	return _walk(params, false)

func walk_block(params):
	return _walk(params, true)

func change_scene(params):
	vm.call_deferred("change_scene", params, current_context)
	current_context.waiting = true
	return vm.state_yield

func spawn(params):
	return vm.spawn(params)

func jump(params):
	vm.jump(params[0])
	return vm.state_jump

func dialog_config(params):
	vm.dialog_config(params)
	return vm.state_return

### end command

func run(context):
	var cmd = context.instructions[context.ip]
	if cmd.name == "label":
		return vm.state_return
	if !vm.test(cmd):
		return vm.state_return
	#print("name is ", cmd.name)
	#if !(cmd.name in self):
	#	vm.report_errors("", ["Unexisting command "+cmd.name])

	return call(cmd.name, cmd.params)

func resume(context):
	current_context = context
	if context.waiting:
		return vm.state_yield
	var count = context.instructions.size()
	while context.ip < count:
		var top = vm.stack.size()
		var ret = run(context)
		context.ip += 1
		if top < vm.stack.size():
			return vm.state_call
		if ret == vm.state_yield:
			return vm.state_yield
		if ret == vm.state_call:
			return vm.state_call
		if ret == vm.state_break:
			if context.break_stop:
				break
			else:
				return vm.state_break
		if ret == vm.state_repeat:
			context.ip = 0
		if ret == vm.state_jump:
			return vm.state_jump
	context.ip = 0
	return vm.state_return

func set_vm(p_vm):
	vm = p_vm

func _init():
	#print("*************** vm level init")
	#vm = get_scene().get_singleton("vm")
	pass
