extends Control

var vm
var cmd
var vbox
var context
var item
var animation
var ready = false
var option_selected

func selected(n):
	if !ready:
		return
	option_selected = n
	animation.play("hide")
	ready = false

func start(params, p_context):
	stop()
	context = p_context
	cmd = params
	var i = 0
	var visible = 0
	for q in params:
		if !vm.test(q):
			i+=1
			continue
		var it = item.duplicate()
		var but = it.get_node("button")
		var label = but.get_node("label")
		label.set_text(q.params[0])
		but.connect("pressed", self, "selected", [i])
		vbox.add_child(it)
		i+=1
		visible += 1
	while visible < 4:
		var it = item.duplicate()
		it.get_node("button").set_disabled(true)
		vbox.add_child(it)
		visible+=1
	ready = false
	animation.play("show")

func stop():
	hide()
	while vbox.get_child_count() > 0:
		vbox.remove_and_delete_child(vbox.get_child(0))

func anim_finished():
	var cur = animation.get_current_animation()
	if cur == "show":
		ready = true
	if cur == "hide":
		vm.finished(context)
		vm.add_level(cmd[option_selected].params[1], false)
		stop()

func _ready():
	hide()
	vm = get_scene().get_singleton("vm")
	vbox = get_node("anchor/scroll/vbox")
	vbox.set_stop_mouse(false)
	add_to_group("dialog_dialog")
	item = get_node("item")
	item.get_node("button/label").set_stop_mouse(false)
	item.get_node("button").set_stop_mouse(false)
	item.set_stop_mouse(false)
	call_deferred("remove_child", item)
	animation = get_node("animation")
	animation.connect("finished", self, "anim_finished")
	get_node("anchor/scroll").set_theme(preload("res://game/globals/dialog_theme.xml"))

