extends Node

var context
var text
var elapsed = 0
var total_time
var character
var vm
var speed = 45.0 # characters per second
var finished = false
var play_intro = true
var play_outro = true
var label

export var fixed_pos = false

func _process(time):
	elapsed += time
	if elapsed >= total_time:
		label.set_visible_characters(label.get_total_character_count())
		set_process(false)
		return
	else:
		label.set_visible_characters(text.length() * elapsed / (total_time))

func skipped():
	if finished:
		return
	if elapsed < total_time:
		elapsed = total_time
	else:
		finish()

func finish():
	character.set_speaking(false)
	finished = true
	if has_node("animation") && play_outro:
		var anim = get_node("animation")
		if anim.has_animation("hide"):
			anim.play("hide")
		else:
			_queue_free()
	else:
		_queue_free()

func init(p_params, p_context, p_intro, p_outro):
	character = vm.get_object(p_params[0])
	context = p_context
	text = p_params[1]
	play_intro = p_intro
	play_outro = p_outro
	total_time = text.length() / speed
	if !fixed_pos:
		var pos
		print("character ", character)
		if character.has_node("dialog_pos"):
			pos = character.get_node("dialog_pos").get_global_pos()
		else:
			pos = character.get_pos()
		set_pos(pos)

	if has_node("anchor/avatars"):
		var avatars = get_node("anchor/avatars")
		if avatars.get_child_count() > 0:
			var name
			if p_params.size() < 4:
				name = avatars.get_child(0).get_name()
			else:
				name = p_params[3]
			for i in range(0, avatars.get_child_count()):
				var c = avatars.get_child(i)
				if c.get_name() == name:
					c.show()
				else:
					c.hide()

	character.set_speaking(true)
	get_scene().call_group(0, "game", "set_mode", "dialog")
	if has_node("animation") && play_intro:
		var anim = get_node("animation")
		if anim.has_animation("show"):
			if self.is_type("Node2D"):
				hide()
			anim.play("show")
		else:
			if self.is_type("Node2D"):
				show()
			set_process(true)
	else:
		show()
		set_process(true)
	label.set_text(text)
	label.set_visible_characters(0)

func _queue_free():
	queue_free()
	get_scene().call_group(0, "game", "set_mode", "default")
	vm.finished(context)


func anim_finished():
	var cur = get_node("animation").get_current_animation()
	if cur == "show":
		set_process(true)
	if cur == "hide":
		_queue_free()

func _ready():
	vm = get_scene().get_singleton("vm")
	add_to_group("events")
	if has_node("animation"):
		get_node("animation").connect("finished", self, "anim_finished")
	label = get_node("anchor/text")

