/// Template file v5.12 (07/27/01)
////////////////////////////////////////////////////////////////////////
// File: doors.wdl
//		WDL prefabs for doors, platforms, gates, switchs, etc
////////////////////////////////////////////////////////////////////////
// Version 4.20
////////////////////////////////////////////////////////////////////////
// ACTIONS:
//
//	FUNCTIONS:
//
//
// Mod: 06/08/01 DCP
//		_elevator_target() & _door_swing(): Replace move() with ent_move()
//
// Mod Date: 6/19/01 DCP
//		_key_pickup(): Added wait before remove to avoid "dangerous action" error
//
// Mod 07/03/01 DCP
//		elevator_move() & _door_swing(): Fixed error when elevator/door travels over long distances

//////////////////////////////////////////////////////////////
// gekrzte angepasste veraenderte datei von original doors.wdl,
// nicht bentigte funktionen wurden rausgenommen
////////////////////////////////////////////////////////////////
//

IFNDEF DOORS_DEF;
 SOUND open_snd <door_op.wav>;
 SOUND close_snd <door_cl.wav>;
 SOUND trigger_snd <click.wav>;
 SOUND key_fetch <beamer.wav>;
ENDIF;

var temp_dist = 0; 	
var temp_dist2 = 0; 

///////////////////////////////////////////////////////////////////////

DEFINE _ENDPOS_X,SKILL1;	
DEFINE _ENDPOS_Y,SKILL2;
DEFINE _ENDPOS_Z,SKILL3;	
DEFINE _ENDPOS,SKILL3;	

DEFINE _PAUSE,SKILL6;		
DEFINE _TRIGGER_RANGE,SKILL7;	
DEFINE _SWITCH,SKILL8;		

DEFINE _CURRENTPOS,SKILL9;
DEFINE _TRIGGERFRAME,SKILL10;	
DEFINE _STARTPOS_X,SKILL27;	
DEFINE _STARTPOS_Y,SKILL28;
DEFINE _STARTPOS_Z,SKILL29;	

DEFINE __ROTATE,FLAG1;	
DEFINE __SILENT,FLAG2;	
DEFINE __GATE,FLAG5;		
DEFINE __REMOTE,FLAG6;	
DEFINE __LID,FLAG7;		

DEFINE __MOVING,FLAG8;  

///////////////////////////////////////////////////////////////////////

var	doorswitch_states = 0;	

function doorswitch_event()
{
	_doorevent_check();
	if(RESULT) { doorswitch_states ^= MY._SWITCH; }	
}

ACTION	doorswitch
{
	MY.EVENT = doorswitch_event;
	_doorevent_init();

	if(MY._SWITCH == 0) { MY._SWITCH = 1; }	// default to switch 1

}

function _doorswitch_reset_all()
{
	doorswitch_states = 0;
}


function _door_use_switch()
{
	while(1)
	{

		if((MY._SWITCH & doorswitch_states) != 0)
		{

			_door_swing();

			while((MY._SWITCH & doorswitch_states) != 0)
			{

				waitt(16);
			}
			_door_swing();

		}
		waitt(16);
 	}
}


function door_event()
{
	_doorevent_check();
	if(RESULT) { _door_swing(); }
}


ACTION door
{
	MY.EVENT = door_event;
	_doorevent_init();
	if(MY._FORCE == 0) { MY._FORCE = 5; }
	if(MY._ENDPOS == 0) { MY._ENDPOS = 90; }
}


function _doorevent_close()
{
	wait(4);

	if((TOTAL_FRAMES > MY._TRIGGERFRAME + 3)
		&& (MY._CURRENTPOS == MY._ENDPOS)
		&& (MY.__MOVING == OFF))
	{
		_door_swing();
		return;
	}
}


function _door_swing()
{
	MY.__MOVING = ON;

	if(MY.__GATE == ON)
	{
		if(MY.__SILENT == OFF) { PLAY_ENTSOUND ME,open_snd,66; }

		// open gate
		while(MY.__MOVING == ON)
		{
			wait(1);	
			
			MY._SPEED_X = MY._TARGET_X - MY.X;
			MY._SPEED_Y = MY._TARGET_Y - MY.Y;
			MY._SPEED_Z = MY._TARGET_Z - MY.Z;

			temp = MY._FORCE * TIME; 

			
			if(vec_length(my._speed) > temp)
			{
				
				vec_normalize(MY._SPEED,temp);
			}
			else
			{
				
				MY.__MOVING = OFF;
			}

			move_mode = ignore_passable + ignore_push + activate_trigger + glide;
			result = ent_move(NULLSKILL,MY._SPEED);

			if(RESULT == 0)
			{
				break;
			}

			MY._SPEED_X = MY_SPEED.X;	
			MY._SPEED_Y = MY_SPEED.Y;	
			MY._SPEED_Z = MY_SPEED.Z;
		}

		MY._SPEED_X = 0;
		MY._SPEED_Y = 0;
		MY._SPEED_Z = 0;

		MY.__MOVING = OFF;

		if(  (MY._TARGET_X == MY._ENDPOS_X)
			&&(MY._TARGET_Y == MY._ENDPOS_Y)
			&&(MY._TARGET_Z == MY._ENDPOS_Z))
		{
			MY._TARGET_X = MY._STARTPOS_X;
			MY._TARGET_Y = MY._STARTPOS_Y;
			MY._TARGET_Z = MY._STARTPOS_Z;

			if(MY._PAUSE > 0)
			{
 				waitt(MY._PAUSE);
				_door_swing();	
				return;
			}

		}
		else
		{
			MY._TARGET_X = MY._ENDPOS_X;
			MY._TARGET_Y = MY._ENDPOS_Y;
			MY._TARGET_Z = MY._ENDPOS_Z;
		}

		return; 
	} 

	if(MY._CURRENTPOS < MY._ENDPOS)
	{
		if(MY.__SILENT == OFF) { PLAY_ENTSOUND ME,open_snd,66; }
		while(MY._CURRENTPOS < MY._ENDPOS)
		{
			if(MY.__LID == ON)
			{
				MY.ROLL += MY._FORCE*TIME;
			}
			else
			{
				MY.PAN -= MY._FORCE*TIME;
			}
			MY._CURRENTPOS += ABS(MY._FORCE)*TIME;
			wait(1);
		}
		if(MY.__LID == ON)
		{
			MY.ROLL -= MY._CURRENTPOS-MY._ENDPOS;
		}
		else
		{
			MY.PAN += MY._CURRENTPOS-MY._ENDPOS;
		}
		MY._CURRENTPOS = MY._ENDPOS;
		if(MY.__LID == ON)
		{
			MY.PASSABLE = ON;
		}
	}
	else 
	{
		if(MY.__SILENT == OFF) { play_entsound(ME,close_snd,66); }
		while(MY._CURRENTPOS > 0)
		{
			if(MY.__LID == ON)
			{
				MY.ROLL -= MY._FORCE*TIME;
			}
			else
			{
				MY.PAN += MY._FORCE*TIME;
			}
			MY._CURRENTPOS -= abs(MY._FORCE)*TIME;
			wait(1);
		}
		if(MY.__LID == ON)
		{
			MY.ROLL -= MY._CURRENTPOS;
		}
		else
		{
			MY.PAN += MY._CURRENTPOS;
		}
		MY._CURRENTPOS = 0;
		if(MY.__LID == ON)
		{
			MY.PASSABLE = 0;
		}
	}
	MY.__MOVING = OFF;
}


function _doorevent_init()
{
	MY.ENABLE_SCAN = ON;
	MY.ENABLE_rightCLICK = ON;

	if(MY._TRIGGER_RANGE >= 2)
	{
		MY.ENABLE_TRIGGER = ON;
		MY.TRIGGER_RANGE = MY._TRIGGER_RANGE;
	}

	if(MY._TRIGGER_RANGE == 1)
	{
		MY.ENABLE_SONAR = ON;
	}

	if(MY.STRING1 != NULL)
	{
		MY.ENABLE_TOUCH = ON;
	}

	MY._TRIGGERFRAME = 0;
	MY.PUSH = 10;

	if(MY._SWITCH != 0)
	{
		_door_use_switch();
	}
}


function _doorevent_check()
{
	handle_touch();	
	if(MY.__MOVING == ON) { goto(ignore); }	

	if((EVENT_TYPE == EVENT_SCAN) && (indicator == _HANDLE))
		|| (EVENT_TYPE == EVENT_rightCLICK)
	{
		if(MY.__SILENT == OFF) { play_sound(trigger_snd,50); }
		goto(operate);
	}

	if(EVENT_TYPE == EVENT_TRIGGER)
	{
		if((MY._CURRENTPOS != MY._ENDPOS)
			&& (TOTAL_FRAMES > (MY._TRIGGERFRAME + 2)))
		{
			MY._TRIGGERFRAME = TOTAL_FRAMES;
			goto(operate);
		}
		MY._TRIGGERFRAME = TOTAL_FRAMES;

		_doorevent_close();
	}

	if(EVENT_TYPE == EVENT_SONAR)
	{
		if(TOTAL_FRAMES > (MY._TRIGGERFRAME + 5))
		{
			MY._TRIGGERFRAME = TOTAL_FRAMES;
			goto(operate);
		}

		MY._TRIGGERFRAME = TOTAL_FRAMES;
	}

ignore:
	RESULT = 0;
	return(0);

operate:
	RESULT = 1;
	return(1);
}


ACTION item_rotate
{

	MY._STARTPOS_X = MY.X;
	MY._STARTPOS_Y = MY.Y;
	MY._STARTPOS_Z = MY.Z;

	while(MY.INVISIBLE == OFF
		&& MY._STARTPOS_X == MY.X
		&& MY._STARTPOS_Y == MY.Y
		&& MY._STARTPOS_Z == MY.Z)
	{
		MY.PAN += 3*TIME;
		wait(1);
	}
}


ACTION item_pickup
{
	MY.PUSH = -1;
//	MY.ENABLE_SCAN = ON;	
	MY.ENABLE_rightCLICK = ON;	
	MY.ENABLE_PUSH = ON;	

	if(MY.__ROTATE == ON) { item_rotate(); }
}

